/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.pa.fedc;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.pa.fedc.FEDCCollectionAgent;
import com.ibm.hwmca.fw.pa.fedc.FEDCKey;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfaces;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.fedc.FEDCFileDescriptor;
import java.util.ArrayList;
import java.util.List;

public class LogCollectionAgent {
    private static final String TRACE_MASKT = "XPALFEDT";
    private static final String TRACE_MASKF = "XPALFEDF";
    private static final String TRACE_MASKD = "XPALFEDD";

    public static String[] getFileList(Log log) throws HException {
        Trace.trace(TRACE_MASKT, "--> getFileList()");
        Object defaultList = null;
        List defaultResolvedList = null;
        List keyList = null;
        ArrayList combinedList = new ArrayList(10);
        String[] sArray = null;
        boolean getDefaultList = true;
        boolean logHasSystemInfo = false;
        FEDCKey key = null;
        FEDCCollectionAgent agent = null;
        if (!logHasSystemInfo) {
            agent = (FEDCCollectionAgent)ServiceInterfaces.getFactory("com.ibm.hwmca.fw.pa.system.PASystem", "FEDCCollectionFactory");
        }
        if (getDefaultList) {
            defaultResolvedList = agent.getResolvedDefaultFileList();
        }
        if (key != null) {
            keyList = agent.getResolvedFileList(key);
        }
        Trace.trace(TRACE_MASKD, "the default list is " + defaultResolvedList);
        Trace.trace(TRACE_MASKD, "the keyed list is " + keyList);
        if (defaultResolvedList != null) {
            combinedList.addAll(defaultResolvedList);
        }
        if (keyList != null) {
            combinedList.addAll(keyList);
        }
        int totalNumberOfFiles = combinedList.size();
        Trace.trace(TRACE_MASKD, "total number of file to return is " + totalNumberOfFiles);
        sArray = new String[totalNumberOfFiles];
        int i = 0;
        while (i < totalNumberOfFiles) {
            sArray[i] = ((FEDCFileDescriptor)combinedList.get((int)i)).name;
            Trace.trace(TRACE_MASKD, "added " + sArray[i] + " to the list");
            ++i;
        }
        Trace.trace(TRACE_MASKT, "<-- getFileList()");
        return sArray;
    }

    public static void main(String[] args) {
        try {
            String baseFilePath = BaseFileControl.getFilePath("sysconfig");
            Trace.trace(TRACE_MASKD, "Looking in '" + baseFilePath + "' for system/service config files.");
            ServiceInterfaces.addAllFiles(baseFilePath);
            LogCollectionAgent lca = new LogCollectionAgent();
            String[] aArray = LogCollectionAgent.getFileList(new Log());
            Trace.trace(TRACE_MASKD, "output array is");
            int i = 0;
            while (i < aArray.length) {
                Trace.trace(TRACE_MASKD, "element [" + i + "]=" + aArray[i]);
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got an exception");
            Trace.trace(TRACE_MASKD, e);
        }
    }
}

